<?php
// Include your database connection
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Base query
$sql = "SELECT shippingid, start_range, end_range, flat, weight, rate, free_shipping_amount,expressshipping,mode,shippingtype
        FROM shippingmethod
        WHERE Delete_status = 0";

// Execute the query
$result = $conn->query($sql);

// Prepare the response
if ($result && $result->num_rows > 0) {
    $data = [];

    while ($row = $result->fetch_assoc()) {
        // Creating product_details array
        $shipping_details = [
            'id' => $row['shippingid'],
            'startrange' => $row['start_range'],
            'endrange' => $row['end_range'],
            'flat' => $row['flat'],
            'weight' => $row['weight'],
            'rate' => $row['rate'],
            'freeshipping' => $row['free_shipping_amount'],
            'express' => $row['expressshipping'],
            'mode' => $row['mode'],
            'shippingtype' =>$row['shippingtype']
        ];

        // Append product_details to the data array
        $data[] = $shipping_details;
    }

    // Return JSON response
    echo json_encode($data);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No coupon found']);
}
?>
